#!/bin/bash
#SBATCH --nodes=1          # Αριθμός nodes
#SBATCH --ntasks=1         # Αριθμός MPI Tasks
#SBATCH --ntasks-per-node=1  # Αριθμός MPI Tasks / node
#SBATCH --cpus-per-task=20   # Αριθμός Threads / MPI Task
#SBATCH --mem=56G            # Μνήμη ανά node
#SBATCH -A testproj          # Accounting tag (set2015 για 
                             # όλους στο training)
#SBATCH -p compute           # Σε ποιό partition
#SBATCH -t 24:00:00          # Ζητούμενος χρόνος
module purge
module load gnu
module load intel
module load intelmpi
module load octave

export OMP_NUM_THREADS=$SLURM_CPUS_PER_TASK


for i in 512 1024 2048 4096 8192 16384; do \
    sed -e s/NNN/$i/g matmul.template > matmul.m
    echo $i
    octave matmul.m
done;

