#include <stdio.h>
#include <stdlib.h>
#include <math.h>


int main(int argc, char **argv)
{

int i;
int sizes[]={32,64,128,256,512,1024,2048,4096,8192,16384}; /* 10 sizes */
void dgesv_compare_(int *, double *, double *, double *, int *,double *);
double *a,*b,*x, tblas;
int *ipiv,*indx;
double gflops[3];




printf("#Size     TimeBLAS   GFLOPs\n");
for (i=0;i<10;i++) { 
      a=calloc(sizes[i]*sizes[i],sizeof(double));
      b=calloc(sizes[i],sizeof(double));
      x=calloc(sizes[i],sizeof(double));
      ipiv=calloc(sizes[i],sizeof(int));
      indx=calloc(sizes[i],sizeof(int));
      dgesv_compare_(&sizes[i],a,b,x,ipiv,&tblas);
      gflops[0] = 1.0e-9*( (2.0/3.0)*pow((double)sizes[i],3.0)+2*(double)pow(sizes[i],2.0)) / tblas;
      printf("%6d %10.6lf %8.4lf\n",sizes[i],tblas,gflops[0]);
      free(a); free(b); free(x);
}

return 0;
}

