#include <stdio.h>
#include <stdlib.h>
#include <math.h>


int main(int argc, char **argv)
{

int i;
int sizes[]={32,64,128,256,512,1024,2048,4096,8192,16384}; /* 10 sizes */

void dgemm_compare_(int *,int *, double *, double *, double *, double *);
double *a,*b,*c, tcode, tmatmul,tblas;
double gflops[3];
int nt;


printf("#Size          Time   GFlops\n");
for (i=0;i<10;i++) { 
      a=calloc(sizes[i]*sizes[i],sizeof(double));
      b=calloc(sizes[i]*sizes[i],sizeof(double));
      c=calloc(sizes[i]*sizes[i],sizeof(double));
#if !defined(MATMULCODE) && !defined(MATMULMATMUL) && !defined(MATMULDGEMM)
      printf("Not Matrix MatMul type defined\nExiting\n");
#endif

#ifdef MATMULCODE
      nt=1;
#endif
#ifdef MATMULMATMUL
      nt=2;
#endif
#ifdef MATMULDGEMM
      nt=3;
#endif

      dgemm_compare_(&nt,&sizes[i],a,b,c,&tcode);
      if ( tcode < 0.0 ) { 
          printf ("MATMUL type was not specified during compilation\n");
          exit(1);
      }
      gflops[0] = 2.0e-9*pow(sizes[i],3.0)/tcode;
      printf("%6d %12.6lf %8.3lf\n",
       sizes[i],tcode,gflops[0]);
      free(a); free(b); free(c);
}

return 0;
}

