#!/bin/bash
#
#SBATCH --job-name="checkcomp"
#SBATCH --time=12:00:00
#SBATCH --nodes=1
#SBATCH --ntasks=20
######SBATCH --ntasks-per-node=20
#SBATCH --cpus-per-task=1
#SBATCH --mem=56G
#SBATCH --output=checkcomp.%j.o
#SBATCH --error=checkcomp.%j.e
#SBATCH -A testproj


export OMP_NUM_THREADS=$SLURM_CPUS_PER_TASK
export NUM_THREADS=$SLURM_CPUS_PER_TASK

# ./dgemm_code.O.x > out.O.log 
## ./dgemm_code.O3.x > out.O3.log 
# ./dgemm_code.avx-ivybridge.x > out.avx-ivybridge.log 
# ./dgemm_code.tree-vectorize.x > out.tree-vectorize.log 

 ./dgemm_code.O.intel.x > out.O.intel.log &
 ./dgemm_code.O3.intel.x > out.O3.intel.log &
 ./dgemm_code.avx-ivybridge.intel.x > out.avx-ivybridge.intel.log &
 ./dgemm_code.tree-vectorize.intel.x > out.tree-vectorize.intel.log &

 ./dgemm_code.None.intel.x > out.None.intel.log &
# ./dgemm_code.None.x > out.None.log 


wait



