	subroutine dgesv_compare(NMAX,a,x,b,ipiv,tblas)
        implicit none
        integer NMAX
        real*8 b(NMAX),x(NMAX),a(NMAX,NMAX)
        real*8 err
        real*8 myrandom
        real*8 tzero,tnow
        real*8 tlapack
        real*8 csecond
        real*8 tmin,tmax,tave,titer
        integer i,j,info,lda,ldb,nrhs,n,k
        integer ipiv(NMAX)
        integer iseed
        integer niter
        real*8 tblas
       
        tlapack=0.0
        n=NMAX
         
!  initialize random numbers generator
        call init_randoms_generator(iseed)

! repeat few times : niter = 1
        niter = 1
        tmax=-1.0
        tmin=1.00000000e37
        do k = 1, niter
!  fill array A, vector x with random numbers
        do i = 1,NMAX
           do j = 1,NMAX
              a(j,i)=myrandom(iseed)
           enddo
           x(i)=myrandom(iseed)
        enddo
!   create vector b from known A and x : b=Ax
        do i = 1,NMAX
           b(i)=0.0000000
           do j = 1, NMAX
              b(i)=b(i) + a(j,i) * x(j)
           enddo
        enddo

        nrhs = 1
        lda = NMAX
        ldb = NMAX

        
        tzero=csecond()
           call dgesv(n, nrhs, a, lda, ipiv, b, ldb, info)
           if ( info.ne.0 ) then
                write(*,*)'something found wrong in dgesv '
           endif
        tnow=csecond()
        titer=tnow-tzero
        if (titer.gt.tmax) then 
              tmax=titer
        endif
        if (titer.lt.tmin) then 
              tmin=titer
        endif
        tlapack=tlapack+titer
        enddo

        tave = tlapack/dble(niter)
	tblas=tave
        end

