	subroutine dgemm_smm_compare(M,N,K,a,b,c,
     $                               tcode,tmatmul,tblas,tsmm)
        implicit none
        integer M,N,K
        real*8 a(M,K),b(K,N),c(M,N)
        real*8 err
        real*8 myrandom
        real*8 tzero,tnow
        real*8 tlapack
        real*8 csecond
        real*8 tmin,tmax,tave,titer
        integer i,j,info,lda,ldb,ldc,nrhs,ij
        integer iseed
        integer niter
        real*8 tcode,tmatmul,tblas,tsmm
        real*8 ONE,ZERO
       
        tlapack=0.0
        tcode=0.0
        tmatmul=0.0
        tblas=0.0
        tsmm=0.0
        ONE  = 1.00000000000000000
        ZERO = 0.00000000000000000
!  initialize random numbers generator
        call init_randoms_generator(iseed)

!  fill arrays A,B,C with random numbers (in range -100 - 100)
        do i = 1, K
           do j = 1, M
              a(j,i)=myrandom(iseed)
           enddo
        enddo

        do i = 1, N
           do j = 1, K
              b(j,i)=myrandom(iseed)
           enddo
        enddo
 
        do i = 1,N
           do j = 1,M
              c(j,i)=0.0
           enddo
        enddo

        nrhs = 1
        lda = M
        ldb = K
        ldc = M

        tzero=csecond()
        do i = 1, M
           do j = 1, N
                c(i,j)= 0.00000000000000000
                do ij = 1, K
                  c(i,j)=c(i,j)+a(i,ij)*b(ij,j)
                enddo
           enddo
        enddo
        tnow=csecond()
        tcode=tcode+tnow-tzero

        tzero=csecond()
        c=matmul(a,b) 
        tnow=csecond()
        tmatmul=tmatmul+tnow-tzero

        tzero=csecond()
            call smm_dnn(M,N,K,A,B,C) 
        tnow=csecond()
        tsmm=tsmm+tnow-tzero

        tzero=csecond()
           call dgemm('N','N',M,N,K,ONE,a,lda,b,ldb,ZERO,c,ldc)
        tnow=csecond()
        titer=tnow-tzero
        tblas=tblas+tnow-tzero
        return
        end

