        program md
	implicit none
        include 'mpif.h'
        integer NCELLS,N
        parameter(NCELLS=50)
        parameter(N=NCELLS*NCELLS*NCELLS)
        double precision x(N),y(N),z(N)
        double precision fx(N),fy(N),fz(N)
        double precision global_fx(N),global_fy(N),global_fz(N)
        double precision epot
        double precision dx,dy,dz,dr2,dr
        double precision myrandom
        double precision sigma, epsilon, BoxL,BoxL2
        double precision tzero, tnow, mytimer
        double precision atdensity
        double precision cutoff
        double precision mw, density, molvolume, boxvolume
        double precision sumf2
        integer i,j,ii
c. additional vars : e4=4*e, e24=24*e
        double precision e4,e24
c.vars to keep sigma/r^6 and sigma/r ^12
c. cutsq square of cutoff
        double precision sigr6,sigr12, cutsq, sigr126
        double precision e24sigr126,dxdr,dydr,dzdr
c
        integer me,nprocs,ierror
        integer Status(MPI_STATUS_SIZE)
        integer msgtag,src
        integer k,len,ierr
        character*(MPI_MAX_PROCESSOR_NAME) hn
        double precision tmp1, tmpA(N)
        integer readstatus
	double precision global_epot

        me = -1

c       
        CALL MPI_Init(ierror)

        if ( ierror.ne.MPI_SUCCESS ) then
            write(*,*)'MPI_Init() failed. Error_Code : ',ierror
            stop
        endif

        CALL MPI_Comm_Rank(MPI_COMM_WORLD,me,ierror)

        if ( ierror .ne. MPI_SUCCESS) Then
            write(*,*)'MPI_Comm_Rank() failed. Error_Code : ',ierror
            CALL MPI_Finalize(ierror)
        endif
            
        CALL MPI_Comm_Size(MPI_COMM_WORLD,nprocs,ierror)
        if ( ierror .ne. MPI_SUCCESS) Then
            write(*,*)'MPI_Comm_Size() failed. Error_Code : ',ierror
            CALL MPI_Finalize(ierror)
        endif
    
        call MPI_GET_PROCESSOR_NAME(hn, len, ierr) 

        write(*,'(A4,1X,I4,1X,A4,1X,I4,1X,A4,1X,A10)')
     $ 'proc ',me,' of ',nprocs,' on ',hn


        
        mw = 131.290d0
        epsilon = 221.0d0
        sigma   = 3.9d0
        cutoff = 6.0 * sigma
        cutsq = cutoff * cutoff
       

        e4 = 4.0d0 * epsilon
        e24 = 24.0d0 * epsilon

c Initialize Cubic Cell coordinates, zero energy, zero forces
        epot=0.0d0
        global_epot =0.00000d0
        if (me.eq.0) then
        call ReadInitialConf(N,boxL,x,y,z,readstatus)
        BoxL2=boxL/2.0d0
        if (readstatus.ne.0) then
          write(*,*)'Error in read, Bye'
	  CALL MPI_Finalize(ierror)
        endif


        do i = 1, N
            fx(i)=0.0000000d0
            fy(i)=0.0000000d0
            fz(i)=0.0000000d0
            global_fx(i)=0.0000000d0
            global_fy(i)=0.0000000d0
            global_fz(i)=0.0000000d0
        enddo

       endif

c        Broadcast theese data to all slaves

       call MPI_Bcast(x,N,MPI_DOUBLE_PRECISION,0,
     $                MPI_COMM_WORLD,ierror)
       if ( ierror.ne.MPI_SUCCESS ) then
         write(*,*)'MPI_Bcast() failed. Error_Code : ',ierror
         CALL MPI_Finalize(ierror)
       endif

       call MPI_Bcast(y,N,MPI_DOUBLE_PRECISION,0,
     $                MPI_COMM_WORLD,ierror)
       if ( ierror.ne.MPI_SUCCESS ) then
         write(*,*)'MPI_Bcast() failed. Error_Code : ',ierror
         CALL MPI_Finalize(ierror)
       endif

       call MPI_Bcast(z,N,MPI_DOUBLE_PRECISION,0,
     $                MPI_COMM_WORLD,ierror)
       if ( ierror.ne.MPI_SUCCESS ) then
         write(*,*)'MPI_Bcast() failed. Error_Code : ',ierror
         CALL MPI_Finalize(ierror)
       endif


       call MPI_Bcast(fx,N,MPI_DOUBLE_PRECISION,0,
     $                MPI_COMM_WORLD,ierror)
       if ( ierror.ne.MPI_SUCCESS ) then
         write(*,*)'MPI_Bcast() failed. Error_Code : ',ierror
         CALL MPI_Finalize(ierror)
       endif

       call MPI_Bcast(fy,N,MPI_DOUBLE_PRECISION,0,
     $                MPI_COMM_WORLD,ierror)
       if ( ierror.ne.MPI_SUCCESS ) then
         write(*,*)'MPI_Bcast() failed. Error_Code : ',ierror
         CALL MPI_Finalize(ierror)
       endif

       call MPI_Bcast(fz,N,MPI_DOUBLE_PRECISION,0,
     $                MPI_COMM_WORLD,ierror)
       if ( ierror.ne.MPI_SUCCESS ) then
         write(*,*)'MPI_Bcast() failed. Error_Code : ',ierror
         CALL MPI_Finalize(ierror)
       endif

c  Timer
	tzero = MPI_WTime()

        do ii = 1 + me, N/2 , nprocs
          do k = 1, 2
             if ( k.eq.1) then
               i = ii
             else
               i = n - ii
             endif
            do j = i + 1, N
               dx = x(i) - x(j)
               dy = y(i) - y(j)
               dz = z(i) - z(j)
c  Boundary conditions
               if ( dx .lt. -BoxL2 ) then
                    dx = dx + BoxL
               endif
               if ( dy .lt. -BoxL2 ) then
                    dy = dy + BoxL
               endif
               if ( dz .lt. -BoxL2 ) then
                    dz = dz + BoxL
               endif

               if ( dx .gt. BoxL2 ) then
                    dx = dx - BoxL
               endif
               if ( dy .gt. BoxL2 ) then
                    dy = dy - BoxL
               endif
               if ( dz .gt. BoxL2 ) then
                    dz = dz - BoxL
               endif

               dr2 = dx*dx + dy*dy + dz*dz

c... Cutoff
               if ( dr2.le.cutsq ) then
                 dr  = dsqrt(dr2)
                 sigr6 = (sigma/dr)**6
                 sigr12 = sigr6 * sigr6
                 sigr126=2.0*sigr12 - sigr6
                 dxdr = dx/dr
                 dydr = dy/dr
                 dzdr = dz/dr
                 epot = epot + e4* (sigr12 - sigr6 )
                 e24sigr126 = e24 * sigr126
                 fx(i) = fx(i) - e24sigr126*dxdr
                 fx(j) = fx(j) + e24sigr126*dxdr
                 fy(i) = fy(i) - e24sigr126*dydr
                 fy(j) = fy(j) + e24sigr126*dydr
                 fz(i) = fz(i) - e24sigr126*dzdr
                 fz(j) = fz(j) + e24sigr126*dzdr
               endif
            enddo
          enddo
        enddo

cccc Now collect the results : epot and fx, fy, fz
        
      call MPI_Reduce(epot,global_epot,1,MPI_DOUBLE,MPI_SUM,0,
     $                MPI_COMM_WORLD,ierror)
      call MPI_Reduce(fx,global_fx,N,MPI_DOUBLE,MPI_SUM,0,
     $                MPI_COMM_WORLD,ierror)
      call MPI_Reduce(fy,global_fy,N,MPI_DOUBLE,MPI_SUM,0,
     $                MPI_COMM_WORLD,ierror)
      call MPI_Reduce(fz,global_fz,N,MPI_DOUBLE,MPI_SUM,0,
     $                MPI_COMM_WORLD,ierror)
      call MPI_Barrier(MPI_COMM_WORLD,ierror)

        if ( me .eq. 0 ) then
        tnow = MPI_WTime() - tzero

        global_epot = global_epot / dble(N)
        write(*,1)'Epot     : ',global_epot
        write(*,2)'WallTime : ',tnow
        endif
        
        CALL MPI_Finalize(ierror)

1       format(A10,1X,F15.4)
2       format(A10,1X,F15.4,' sec')
        end

 
c............................................
	Subroutine ReadInitialConf(N,boxL,x,y,z,status)
	implicit none
        integer N
	double precision x(N),y(N),z(N),boxL
        integer i,FD,status,natoms
        FD=22
     

        status=0
        open(FD,file='125katoms.xyz',form='formatted')
        read(FD,*) natoms
        if (natoms .ne. N) then
           write(*,*)'N and atoms in file disagree'
           close(FD)
           status=-1
           return
        endif

	read(FD,*)boxL
        do i = 1, natoms
           read(FD,*)x(i),y(i),z(i)
           x(i)=x(i)*10.0d0
           y(i)=y(i)*10.0d0
           z(i)=z(i)*10.0d0
        enddo

        close(FD)
        return
        end

