        program md
	implicit none
        integer NCELLS,N
        parameter(NCELLS=50)
        parameter(N=NCELLS*NCELLS*NCELLS)
        double precision x(N),y(N),z(N)
        double precision fx(N),fy(N),fz(N)
        double precision epot
        double precision dx,dy,dz,dr2,dr
        double precision myrandom
        double precision sigma, epsilon, BoxL,BoxL2
        double precision tzero, tnow, mytimer
        double precision atdensity
        double precision cutoff
        double precision mw, density, molvolume, boxvolume
        double precision sumf2
        integer i,j
        
        mw = 131.290d0
	density = 1.779800d0
        molvolume =  mw / density
        molvolume = molvolume * dble(N)*1.0d24 / 6.0225d23
c molvolume in Angstrom^3       
        boxL = molvolume**(1.0d0/3.0d0)
        epsilon = 221.0d0
        sigma   = 3.9d0
        cutoff = 6.0 * sigma
        BoxL2=boxL/2.0d0

c Initialize Cubic Cell coordinates, zero energy, zero forces
        call makeInitialConf(N,boxL,x,y,z)

        epot=0.0d0
        do i = 1, N
            fx(i)=0.0000000d0
            fy(i)=0.0000000d0
            fz(i)=0.0000000d0
        enddo

c  Timer
        tzero = mytimer()
        do i = 1, N 
            do j =  1, N
             if ( i .ne. j ) then
               dx = x(i) - x(j)
               dy = y(i) - y(j)
               dz = z(i) - z(j)
c  Boundary conditions
               if ( dx .lt. -BoxL2 ) then
                    dx = dx + BoxL
               endif
               if ( dy .lt. -BoxL2 ) then
                    dy = dy + BoxL
               endif
               if ( dz .lt. -BoxL2 ) then
                    dz = dz + BoxL
               endif

               if ( dx .gt. BoxL2 ) then
                    dx = dx - BoxL
               endif
               if ( dy .gt. BoxL2 ) then
                    dy = dy - BoxL
               endif
               if ( dz .gt. BoxL2 ) then
                    dz = dz - BoxL
               endif

               dr2 = dx*dx + dy*dy + dz*dz
               dr  = dsqrt(dr2)

c... Cutoff
               if ( dr.le.cutoff ) then
                 epot = epot + 4.0d0 * epsilon*((sigma/dr)**12 -
     $                                             (sigma/dr)**6)
                 fx(i) = fx(i) - 24.0*epsilon*(dx/dr)*
     $                   (2.0*(sigma/dr)**12 - (sigma/dr)**6) 
                 fy(i) = fy(i) - 24.0*epsilon*(dy/dr)*
     $                   (2.0*(sigma/dr)**12 - (sigma/dr)**6) 
                 fz(i) = fz(i) - 24.0*epsilon*(dz/dr)*
     $                   (2.0*(sigma/dr)**12 - (sigma/dr)**6) 
               endif
             endif
            enddo
        enddo
c  Energy calculated two times for each pair for example 1-3 and 3-1.
c. On the other hand forces calculated only once (only f(i) added
        epot = epot / 2.0000d0
        tnow = mytimer() - tzero

        epot = epot / dble(N)
        write(*,1)'Epot     : ',epot
        write(*,2)'WallTime : ',tnow
1       format(A10,1X,F15.4)
2       format(A10,1X,F15.4,' sec')
        end

 
c............................................
	Subroutine makeInitialConf(N,boxL,x,y,z)
	implicit none
        integer N
	double precision x(N),y(N),z(N),boxL,un
        integer ndivs,tmp_index
        integer i,j,k,jj
        double precision xa,ya,za
	
        ndivs=int( (N)**(1.0/3.0) + 0.01)
        tmp_index = ndivs*ndivs*ndivs
        if ( tmp_index .ne. N) then
            write(*,*)'N does not corrspond to Cubic Cell'
            stop
        endif
        un = 1.0 / dble(ndivs)

         jj = 0
         xa = -0.5 - 0.5*un
         do i = 1, ndivs
              xa = xa + un
              ya = -0.5 - 0.5*un
           do j = 1,ndivs
              ya = ya + un
              za = -0.5 - 0.5*un
              do k= 1,ndivs
                za = za + un
                jj = jj + 1
                x(jj) = xa
                y(jj) = ya
                z(jj) = za
              enddo
           enddo
         enddo


        do i = 1, N
            x(i) = x(i) * boxL
            y(i) = y(i) * boxL
            z(i) = z(i) * boxL
        enddo

        return
	end

