#!/bin/bash
#
#SBATCH --job-name="testSMP"
#SBATCH --time=01:00:00
#SBATCH --nodes=2
#SBATCH --ntasks-per-node=20
#SBATCH --cpus-per-task=1
#SBATCH --mem=56G
#SBATCH --output=testSMP.%j.o
#SBATCH --error=testSMP.%j.e

#SBATCH -A YOUR_PROJECT_ID_HERE


export OMP_NUM_THREADS=$SLURM_CPUS_PER_TASK
export I_MPI_FABRICS=shm:dapl

module load gnu/4.9.2
module load intel
module load intelmpi
module load ansys

echo "Running on : $SLURM_JOB_NODELIST"

rm -f nodelist.$SLURM_JOB_ID
for n in `echo $SLURM_NODELIST | scontrol show hostnames`;  do \
           echo "$n-ib:$SLURM_NTASKS_PER_NODE" >> nodelist.$SLURM_JOB_ID 
done;

fluent 3d -g -pinfiniband -mpi=intel -cnf=nodelist.$SLURM_JOB_ID -t $SLURM_NTASKS < test_journal.jou  > test_journal.mpitasks.$SLURM_NTASKS.log


rm -f nodelist.$SLURM_JOB_ID


